(function () {
    // For cross browser reasons, the script will take the domain used to load kohlerLoader.js and load all other files from the same domain
    // Example: If source is "http://us.kohler.com/common/js/kohlerLoader.js" the script will understand that the domain to all other files are:
    // http://us.kohler.com/
    var firstDir = 'common';


    // The "Get Site Host" proccess...
    var siteSource = document.getElementById('kohlerLoader').getAttribute('src');
    var siteHost = siteSource.indexOf(firstDir);
    var s = '';
    if(siteHost >= 0) {
        s = siteSource.toString().substr(0, siteHost);
    }

    // Adding the "loadStyles" cascade file...
    var css = document.createElement("link");
    css.type = 'text/css';
    css.href = s + 'common/css/pp_kohler_widget.css';
    css.rel = 'stylesheet';
    document.getElementsByTagName("head")[0].appendChild(css);



    // The method to load a script, with callback when script loads...
    function loadScript(url, callback) {

        var script = document.createElement("script");
        script.type = "text/javascript";

        if (script.readyState) { //IE
            script.onreadystatechange = function () {
                if (script.readyState == "loaded" || script.readyState == "complete") {
                    script.onreadystatechange = null;
                    callback();
                }
            };
        } else { // Others
            script.onload = function () {
                callback();
            };
        }

        script.src = url;
        document.getElementsByTagName("head")[0].appendChild(script);
    }


    // If jQuery are not loaded...
    if(typeof jQuery == 'undefined')
    {
        loadScript(s + "common/com/jquery/jquery-1.9.1.js", function () { // Load jQuery...
            loadScript(s + "common/com/prettyPhoto/jquery.prettyPhoto.js", function () {
    		loadPPcss();
    		// Load prettyPhoto...
                loadScript(s + "common/js/kohlerAppointment.min.js", function () { // Load the kohlerTester...
                    start(); // Executes the start() method
                });
            });
        });
    // If prettyPhoto are not loaded...
    } else if(typeof $.fn.prettyPhoto != 'function')
    {

        loadScript(s + "common/com/prettyPhoto/jquery.prettyPhoto.js", function () {
    			loadPPcss();
    			// Load prettyPhoto...
            loadScript(s + "common/js/kohlerAppointment.min.js", function () { // Load the kohlerTester...
                start(); // Executes the start() method
            });
        });
    } else{
        loadScript(s + "common/js/kohlerAppointment.min.js", function () { // Load the kohlerTester...
            start(); // Executes the start() method
        });
    }
    function loadPPcss(){
    		// Adding the "loadStyles" cascade file...
    		var css = document.createElement("link");
    		css.type = 'text/css';
    		css.href = s + 'common/css/prettyPhoto.css';
    		css.rel = 'stylesheet';
    		document.getElementsByTagName("head")[0].appendChild(css);
    	}

    function start() // The start method, will run as soon as all scripts are loaded.
    {
        kohlerAppointment.start(); // kohlerTester.init() are a method inside "js/kohlerTester.js"
    }
})();